/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.config;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;

public class GenConfig {
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
    public static ForgeConfigSpec.BooleanValue bush_flag;
    public static ForgeConfigSpec.BooleanValue blackberry_flag;
    public static ForgeConfigSpec.BooleanValue blueberry_flag;
    public static ForgeConfigSpec.BooleanValue strawberry_flag;
    public static ForgeConfigSpec.BooleanValue raspberry_flag;
    public static ForgeConfigSpec.BooleanValue tree_flag;
    public static ForgeConfigSpec.BooleanValue apple_flag;
    public static ForgeConfigSpec.BooleanValue apricot_flag;
    public static ForgeConfigSpec.BooleanValue banana_flag;
    public static ForgeConfigSpec.BooleanValue cherry_flag;
    public static ForgeConfigSpec.BooleanValue mango_flag;
    public static ForgeConfigSpec.BooleanValue olive_flag;
    public static ForgeConfigSpec.BooleanValue orange_flag;
    public static ForgeConfigSpec.BooleanValue pear_flag;
    public static ForgeConfigSpec.BooleanValue plum_flag;
    public static ForgeConfigSpec.BooleanValue cactus_flag;
    public static ForgeConfigSpec.BooleanValue wild_crop_flag;
    public static ForgeConfigSpec.BooleanValue wild_plant_flag;
    public static ForgeConfigSpec.BooleanValue marshmallow_flag;
    public static ForgeConfigSpec.BooleanValue chichory_flag;
    public static ForgeConfigSpec.BooleanValue cumin_flag;
    public static ForgeConfigSpec.BooleanValue quinoa_flag;
    public static ForgeConfigSpec.IntValue bush_chance;
    public static ForgeConfigSpec.IntValue cactus_chance;
    public static ForgeConfigSpec.IntValue tree_chance;
    public static ForgeConfigSpec.IntValue wild_crop_chance;
    public static ForgeConfigSpec.IntValue wild_plant_chance;

    public static void init(ForgeConfigSpec.Builder config) {
        config.push("Bush generation");
        bush_flag = config.comment("Indicates whether berry bushes should generate. Ignores flags for specific bushes.").define("Generate berry bushes", true);
        blackberry_flag = config.define("Generate blackberries", true);
        blueberry_flag = config.define("Generate blueberries", true);
        strawberry_flag = config.define("Generate strawberries", true);
        raspberry_flag = config.define("Generate raspberries", true);
        config.pop();
        config.push("Other generation");
        cactus_flag = config.comment("Indicates whether opuntias (cactus crops) should generate").define("Generate opuntias", true);
        wild_crop_flag = config.comment("Enable this feature to generate wild crop blocks that drop seeds.\nIf you want to disable seed drops from grass as well, this must be done in the 'Seed Drop Settings' section.").define("Generate wild crops", false);
        config.pop();
        config.push("Tree generation");
        tree_flag = config.comment("Indicates whether fruit trees should generate. Ignores flags for specific trees.").define("Generate fruit trees", true);
        apple_flag = config.define("Generate apple trees", true);
        apricot_flag = config.define("Generate apricot trees", true);
        banana_flag = config.define("Generate banana trees", true);
        cherry_flag = config.define("Generate cherry trees", true);
        mango_flag = config.define("Generate mango trees", true);
        olive_flag = config.define("Generate olive trees", true);
        orange_flag = config.define("Generate orange trees", true);
        pear_flag = config.define("Generate pear trees", true);
        plum_flag = config.define("Generate plum trees", true);
        config.pop();
        config.push("Plant generation");
        wild_plant_flag = config.comment("Indicates whether wild plants should generate. Ignores flags for specific plants.").define("Generate wild plants", true);
        marshmallow_flag = config.define("Generate marshmallow plants", true);
        chichory_flag = config.define("Generate chichory plants", true);
        cumin_flag = config.define("Generate cumin plants", true);
        quinoa_flag = config.define("Generate quinoa plants", true);
        config.pop();
        config.push("World generation chances");
        bush_chance = config.comment("Chance of berry bushes generating in the overworld. Higher numbers indicate a lower probability (Default: 2000)").defineInRange("Probability of berry bushes generating", 2000, 0, Integer.MAX_VALUE);
        cactus_chance = config.comment("Chance of opuntias generating in deserts. Higher numbers indicate a lower probability (Default: 1500)").defineInRange("Probability of opuntias generating", 1500, 0, Integer.MAX_VALUE);
        tree_chance = config.comment("Chance of fruit trees generating in the overworld. Higher numbers indicate a lower probability (Default: 10000)").defineInRange("Probability of fruit trees generating", 10000, 0, Integer.MAX_VALUE);
        wild_crop_chance = config.comment("Chance of wild crops generating in the overworld. Higher numbers indicate a lower probability (Default: 3000)").defineInRange("Probability of wild crops generating", 3000, 0, Integer.MAX_VALUE);
        wild_plant_chance = config.comment("Chance of wild plants generating in the overworld. Higher numbers indicate a lower probability (Default: 8000)").defineInRange("Probability of wild plants generating", 8000, 0, Integer.MAX_VALUE);
        config.pop();
        config.push("Whitelist and blacklist settings");
        whitelist = config.comment("Enter a dimension location to whitelist feature generation.\nCorrect format -> \"mod_id:dimension\"").defineList("white_dim", Arrays.asList("minecraft:overworld"), (Predicate)new com.google.common.base.Predicate<Object>(){

            public boolean apply(@Nullable Object val) {
                return val instanceof String && val != null;
            }
        });
        blacklist = config.comment("Enter a dimension location to blacklist feature generation.\nCorrect format -> \"mod_id:dimension\"").defineList("black_dim", Arrays.asList("minecraft:nether", "minecraft:end"), (Predicate)new com.google.common.base.Predicate<Object>(){

            public boolean apply(@Nullable Object val) {
                return val instanceof String && val != null;
            }
        });
        config.pop();
    }
}

